function [L alpha_list lenConf lenFree freqConf sizeConf trc_conf trc_free beginConf endConf sizeFree Dlocal] = probaconf_modified(traj, magnif, graph, method, timelag, params)

% function [L alpha_list lenConf lenFree freqConf sizeConf trc_conf trc_free beginConf endConf sizeFree Dlocal] 
%           = probaconf(trc, graph, method, timelag, params)
%
% Disclaimer: Developped for Matlab, not checked for Octave!
%
%Modified to allow the user to choose a subset of the trajectories in traj
%based on length.  This is useful with datasets that include a large number
%of short trajectories (too short to allow reasonable analysis).
%
% EN/ Allows to determine if trajectories display confinement along time. 
% Using a sliding window along the trajectory, we calculate the function 
% of Saxton & Simson / Meilhac (according to the method used). 
% Then we threshold this function, which leads to
% confined events. This calculation is done for all trajs long enough
% and we build the associated statistics (length of confinement...)
%
% Input:    Requirement of the matrix trc is substituted by traj and trc is formed later
%           TRAJ:       Will be converted into a matrix, trc, with five 
%                       columns containing [PID frame xpos ypos zeros]   
%                       for the length of the data (number of rows)
%                       Traj contains all the information learned
%                       about all the particles, stored in columns. A
%                       single trajectory may occupy many sequential rows.
%                       A single row details information about a feature in
%                       a particular frame, or that features trajectory
%                       from the previous frame to that frame.  
%                       The necessary columns are listed below, other
%                       columns can be empty.
%           TRAJ(:,1)   The x centroid positions, in pixels
%           TRAJ(:,2)   The y centroid positions, in pixels
%           TRAJ(:,6)   The frame number (real frame number) of this row.
%           TRAJ(:,7)   The unique particle ID of this particle
%
%               graph: plot or not data
%               Method = 'conf' (Saxton), 'dens' (Douglass) or 'varM' (Meilhac, def)
%               timelag in ms (def 36)
%               param = [Lc tc Sm], threshold, min. time and calculation
%               window, set at 5 3 4
%       def: params = load('../carto/proba_conf_params_varM.dat');
%
% Output:   
%           L           1-D array of all confinement level values
%                       calculated for each trajectory, separated by zeros
%                       at the beginning (due to size of wconf/Sm), length
%                       is sum of steps from all trajectories
%           alpha_list  1-D array of the fraction of confined steps, alpha,
%                       for each trajectory, length is number of trajectories
%           lenConf     1-D array of the length of each 'confined' event in sec,
%                       length depends on the number of confined events
%           lenFree     same for 'free' events
%           freqConf    1-D array of the average frequency of confinement for each
%                       trajectory in 1/seconds, length is the number of
%                       trajectories
%           sizeConf    1-D array of the radius of confined zones in
%                       microns for all trajectories, length depends on the number of confined
%                       events
%           trc_conf    Matrix containing all the confined portions of the trajectories, column 1
%                       is the particle ID, column 2 is the frame number,
%                       column 3 is x position in microns, column 4 is y
%                       position in microns, length depends on the number
%                       of confined steps
%           trc_free    Same for free portions, total length of trc_conf
%                       and trc_free is total number of steps in all
%                       trajectories
%           beginConf   Array of counters for the beginning of confinement,
%                       use for labeling confined and free portions, in frames
%           endConf     Same for the end of confinement
%           sizeFree    1-D array of the radius of free zones in
%                       microns for all trajectories, length depends on the number of confined
%                       events
%           Dlocal      1-D array of instantaneous diffusion coefficients
%                       calculated for each point in each trajectory, in
%                       microns2/second, length is the total number of
%                       steps in all trajectories

%           3 graphs, trajectory with zone(s) of confinement in orange, 
%               the diffusion coefficient vs time,
%               and the function of confinement vs time, with the threshold
%               used
%
%           lenConf, lenFree- length of confined and free portions, in
%               seconds
%           sizeConf, sizeFree- radii of confined and free portions, in
%               microns
%
% cf Simson 95 et Saxton 93, Douglass 2005, Meilhac 2006
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FR/ Elle permet de dterminer sil y a au cours du temps des confinements des
% trajectoires. A laide dune fentre glissante qui parcours la trajectoire
% on calcul la fonction de Saxton & Simson/Meilhac (selon method). 
% Puis on seuil cette fonction ce qui nous
% donne les pisodes confins. On effectue ce calcule sur toutes les
% trajectoires assez longues et on calule les statistiques associes
% (longueur de ces confinements...)
%
% En entre :   ncessite la matrice .trc 
%               graph: plot ou non data
%               Method = 'conf' (Saxton), 'dens' (Douglass) ou 'varM' (Meilhac, def)
%               timelag en ms (def 36)
%               param = [Lc tc Sm], seuil, temps min. et fenetre de calcul
%       def: params = load('../carto/proba_conf_params_varM.dat');
%
% En sortie :   On a 3 graphiques, la trajectoire avec la/les zone(s) de
%               confinement en orange, le coefficient de diffusion en
%               fonction du temps, et la fonction de confinement au cours du
%               temps et le seuil utilis.
%
% cf Simson 95 et Saxton 93, Douglass 2005, Meilhac 2006
%
%
%Written by Arnauld Serge, Didier Marguet et al, published in Marguet, Nat Methods, 5(8),
%687-694, 2008, Dynamic MPT to probe spatiotemporal cartography
%
%Modified by Lindsay Elliott, UIUC and ND, 5/30/2010 to accept inputs from
%another tracking program with output matrix traj and to fit tracking data.


% V1.2 dec 2006 ajout codage var
% V1.3 oct 2007 pour var(R), R2=(x(i)-x(Sm/2))2+(y y), sur fenetre de Sm (wn) points (Sm+1 initialmt)

if nargin<1,
%     cd('../data')
    trc = detect_reconnex_to_trc('../data/EGFR-Qd605.stk'); 
end

if nargin>2 %if traj is read in, put relevent information into trc from it
    trc = zeros(size(traj,1),5);
    trc(:,1) = traj(:,7); %PID
    trc(:,2) = traj(:,6); %frame number
    trc(:,3) = traj(:,1)*16/magnif; %x pos, converted to microns
    trc(:,4) = traj(:,2)*16/magnif; %y pos, converted to microns
end

if nargin<3, graph = 1; end
if nargin<4, method = 'varM'; end
if nargin<5, timelag = 36; end % ms..
if nargin<6, params = load('/carto/proba_conf_params_varM.dat'); end
Lc = params(1);
tc = round(params(2)*30/timelag); %given in frames, normalized for kinetic cycle time by a common value of 30 ms
%temps conf min, en # image (=69 chez simson), Min conf time, image # (= 69 in simson)
%tc = params(2);
Sm = round(params(3)*30/timelag); %same here
%Sm = params(3);

if isempty(trc), Ntraj = 0; else Ntraj_all = trc(end,1); end
global TRAJN_ALL
global TRAJN
if isempty(TRAJN_ALL), TRAJN_ALL = 1:Ntraj_all; end % n of trajs to test
if length(TRAJN_ALL)==Ntraj_all, newfigs = 0; else newfigs = 1; end % si slection restreinte, figs indep 

%If wanted, uncomment the following section and choose a cutoff for size(trc_part,1) > XXX
%This will use trajectories longer than XXX for the rest of the analysis.
%trc_long = [];
%PID=unique(trc(:,1));
%PID=setdiff(PID,0);
%for a = 1:length(PID) 
%    Ppos=trc(:,1)==PID(a);
%    trc_part = trc(Ppos,:);
%    if size(trc_part,1) > XXX
%        trc_long = cat(1,trc_long,trc_part);
%    end
%    clear trc_part
%end
%trc = trc_long;

%Find the new PIDs and number of trajectories
new_PIDs = unique((trc(:,1)));
Ntraj = length(new_PIDs);
TRAJN = 1:Ntraj;

Tmax = size(trc,1);
L = zeros(Tmax,1);
freqConf = zeros(1,Ntraj);
lenConf = cell(1,Ntraj);
lenFree = cell(1,Ntraj);
sizeConf = cell(1,Ntraj);
sizeFree = cell(1,Ntraj);
beginConf = cell(1,Ntraj); % 31/5/7
endConf = cell(1,Ntraj);
trc_conf = [];
trc_free = [];
Nconf = zeros(1,Ntraj);
Dlocal = zeros(Tmax,1);
alpha_list = zeros(Ntraj,1); 

if isempty(trc), 
    lenConf = []; lenFree = []; sizeConf = []; beginConf = []; endConf = []; sizeFree = [];
    if graph, disp('no traces...'), end
    return
end

%Scale Dglobal as needed to correctly identify 'free' and 'confined'
%portions of trajectories.
%Dglobal = 0.25*timelag/36; % pxl/lag, rescal!!!timelag AS 5/4/7%%%%%%%%%(0.22*0.16^2)/0.036 ; %en m/ original line from Serge, Marguet
%Dglobal = 0.25*timelag; %used for trajectory analysis methods paper, molecules 1-5, D ~0.25 um2/sec
%Dglobal = 2*0.25*timelag; %for R6G molecules from 100816 movies, moving slightly faster D ~ 0.35 um2/sec
%Dglobal = timelag/1200; %for DiI C5 33Cnr7, D ~ 0.045 um^2/sec
Dglobal = timelag/1000; %used for simulated walks analysis, Dslow = 0.01 um2/sec, Dfast = 0.1 um2/sec

ifree = 1; iconf = 1;
length_prev_trc = 0;

color_dif = [.5 0 0]; % bordeaux
color_conf = [1 .5 0]; % orange
    
if Ntraj>trc(1,1) % => plusieurs trajs
    disp('detect conf dans traj:             '), 
end

for itraj = TRAJN_ALL %1:Ntraj%
   
    indi = find(trc(:,1)==itraj);
    trci = trc(indi,:);
    nfinal = size(trci,1);
    
    if mod(itraj,20)==0 && Ntraj>trc(1,1)
        fprintf(repmat('\b',1,13))
        fprintf('%6i/%6i', itraj, Ntraj)
    end

%% ****** index de confinement Li ******
    if nfinal>Sm %&& nfinal >49
        Li = zeros(nfinal-Sm+1,1);
        Dlocali = zeros(nfinal-Sm+1,1);      

        for n = 1:nfinal-Sm+1 % NB fenetre glissante #n
            trcn = trci(n:n+Sm-1,:); % bout de trace #n
            xn = trcn(:,3); yn = trcn(:,4);
            R = sqrt((xn-xn(ceil(Sm/2))).^2 + (yn-yn(ceil(Sm/2))).^2); 
            % ref: 1e point (cf Simson) (milieu du tronon, Sm/2??) 

            if graph || nargout>10
                msdn = msd(trcn,1,0);
                DD = calculDinst(msdn,Sm-1); % [n D sD]
                Dlocali(n) = max(DD(2),0); % Diff instantane pour ce troncon (<0 foireux...)
            end

%%  **** fct de Saxton ou variantes de Meilhac / Douglass ****
            switch method
%                 case 'conf'
%                     Li(n) = 2.5117*(Dglobal)*Sm / R2mean(n) - 0.2048 - 1;
%                     %Dtrc(itraj)*.16^2/(timelag/1000)
                case 'varM'
                warning off MATLAB:divideByZero;
                    Li(n) = Dglobal*Sm / var(R); % Meilhac
%                 case 'dens'
%                     distn = sqrt((xi-xi(n)).^2 + (yi-yi(n)).^2); 
%                     surf = (150^2)/(160^2); % surf lem (surface comp), (150 nm)^2, cf. Douglass, Cell 2005, avec 1pxl = 160nm
%                     Li(n) = sum(distn<=sqrt(surf)); % densit = nb de points ds voisinage 
%                                                       density = number of points near ds
                otherwise
                    disp('Wrong method name!')
            end
        end % for n = 1:nfinal-Sm % NB fenetre glissante #n

%% dtermination des pisodes confins %%
        Nconf(itraj) = sum(diff(Li>Lc)==1); % nombre d'pisodes conf. (transitions Li<=Lc  Li>Lc)
        begin_conf = find(diff(Li>Lc)==1)+1; % index (vectoriel) des moments o Li>Lc, cad qu'on devient conf (image suivante, dc +1)
        end_conf = find(diff(Li>Lc)==-1); % plus prcisment, index des moments o l'on redevient non conf, sur le critre Li<=Lc

        if Li(1)>Lc, begin_conf = [1; begin_conf]; end %else end_conf = [1; end_conf]; end % on commence confin (ou non!)
        if Li(end)>Lc, end_conf = [end_conf; length(Li)]; end %else begin_conf = [begin_conf; length(Li)]; end % on termine...

        length_conf_events = end_conf - begin_conf; % dure des confinements, par dfinition... (R), y compris too short,  ce niveau

%% cut off the too short events
        ind_too_short = (length_conf_events < tc);
        begin_conf (ind_too_short) = [];
        end_conf (ind_too_short) = [];

        length_conf_events = end_conf - begin_conf;
        length_free_events = begin_conf(2:end) - end_conf(1:end-1);
        Nconf(itraj) = length(end_conf);

        if ~isempty(begin_conf) %% gestion 1e et dernier
            if Li(1)<=Lc, length_free_events = [begin_conf(1); length_free_events]; end
            if Li(end)<=Lc, length_free_events = [length_free_events; length(Li) - end_conf(end)]; end
        else 
            if Li(1)<=Lc, length_free_events = length(Li); end % free tout du long sur cette traj
        end
        if isempty(end_conf) && Li(1)>Lc, length_conf_events = length(Li); end        % conf " " " (rem: cas dj pris en compte + haut??..)

%% calcul taille, dure & frq. (load size, length & freq.)
        if Nconf(itraj)>0

            freq = zeros(1,Nconf(itraj)-1);
            size_conf_events = zeros(1,Nconf(itraj));
            size_free_events = zeros(1,Nconf(itraj)+1);
            
            %% gestion 1e et dernier
            if Li(1)<=Lc, size_free_events(1) = calcul_size(trci(1:begin_conf(1),:)); end
            if Li(end)<=Lc, size_free_events(end) = calcul_size(trci(end_conf(end):length(Li),:)); end

            for paulo = 1:Nconf(itraj) % boucle sur confs de itraj, loop through conf itraj
                if paulo<Nconf(itraj)
                    freq(paulo) = 1/(begin_conf(paulo+1)-begin_conf(paulo)); 
                    size_free_events(paulo+1) = calcul_size(trci(end_conf(paulo):begin_conf(paulo+1),:));
                end                    
                %size (R2 max) of SS # Don confined itraj end_conf (paulo)-1??
                size_conf_events(paulo) = calcul_size(trci(begin_conf(paulo):end_conf(paulo),:)); %% taille (R2 max) du ss dom confin #itraj  end_conf(paulo)-1??
            end
            
            size_free_events = size_free_events(size_free_events>0);
            if Nconf(itraj)>1, freqConf(itraj) = mean(freq); end
            if ~isempty(length_conf_events), lenConf{itraj} = length_conf_events'; end
            if ~isempty(length_free_events), lenFree{itraj} = length_free_events'; end
            if ~isempty(size_conf_events), sizeConf{itraj} = size_conf_events; end
            if ~isempty(size_free_events), sizeFree{itraj} = size_free_events; end
            
            if ~isempty(begin_conf), beginConf{itraj} = begin_conf+length_prev_trc+ceil((Sm-1)/2); end
            if ~isempty(end_conf), endConf{itraj} = end_conf+length_prev_trc+ceil((Sm-1)/2); end
            
%% matrices trajs free/conf
            if begin_conf(1)>1 % on commence non confin, bug corr. 14/2/7 (StV!)
                index_free = 1:begin_conf(1);
                trc_free = [trc_free; [ifree*ones(length(index_free),1) trci(index_free,2:end)]];
                ifree = ifree+1;
            end

            for paulo = 1:Nconf(itraj)

                if paulo<Nconf(itraj)
                    index_free = end_conf(paulo):begin_conf(paulo+1);
                    trc_free = [trc_free; [ifree*ones(length(index_free),1) trci(index_free,2:end)]];
                    ifree = ifree+1;
                end

                index_conf = begin_conf(paulo):end_conf(paulo);
                %RDpaulo = calculRD(msd(trci(index_conf,2:end,1,0)));
                %if RDpaulo<RDmax % carte trajs linaires (>m+3std)
                    trc_conf = [trc_conf; [iconf*ones(length(index_conf),1) trci(index_conf,2:end)]];
                    iconf = iconf+1;
                %end
            end

            if end_conf(end)<length(Li) % on termine non confin, ajout 14/2/7 (StV!)
                index_free = end_conf(end):length(Li);
                trc_free = [trc_free; [ifree*ones(length(index_free),1) trci(index_free,2:end)]];
                ifree = ifree+1;
            end

        else % pas de changement d'tat: tout free ou ... no change of status: any free or...
            if Li(1)<=Lc
                trc_free = [trc_free; [ifree*ones(nfinal,1) trci(:,2:end)]];
                ifree = ifree+1;
                lenFree{itraj} = length(Li);
                sizeFree{itraj} = calcul_size(trci);
            else %... tout conf ...any conf
                trc_conf = [trc_conf; [iconf*ones(nfinal,1) trci(:,2:end)]];
                iconf = iconf+1;
                lenConf{itraj} = length(Li);
                sizeConf{itraj} = calcul_size(trci);
             end
        end % if Nconf(itraj)>0
        
%% ***************** PLOTS **************
        Tc = sum(lenConf{itraj}); Tf = sum(lenFree{itraj});
        alpha = Tc/(Tc+Tf);
        alpha_list(itraj) = alpha;
        if graph %&& Nconf(itraj)>2 && Nconf(itraj)<10 && alpha>.3 && alpha<.7 && length(Li)>100
%% traj
            if newfigs || itraj==TRAJN(1), figure('WindowStyle','docked'), else clf, end
            subplot(1,2,1)
            x = trci(:,3)*.16; y = trci(:,4)*.16; % current trc, #i
            plot(x-x(1),y-y(1),'Color',color_dif), hold on, plot(0,0,'ob')
            %plot(x,y,x(1),y(1),'og')
            axis ij % hold on
            
%% ajout des ss domaines confs
            if ~isempty(Lc)
                xconf = cell(1,Nconf(itraj)); yconf = cell(1,Nconf(itraj));
                for nconf=1:Nconf(itraj)
                    xconf{nconf} = x(begin_conf(nconf):end_conf(nconf)-1);
                    yconf{nconf} = y(begin_conf(nconf):end_conf(nconf)-1);
                    %plot(xconf{nconf},yconf{nconf},'-r')
                    plot(xconf{nconf}-x(1),yconf{nconf}-y(1),'Color',color_conf)
                end
            end
            hold off
            xlabel('x (m)'), ylabel('y (m)'), title(['traj ' num2str(itraj)])
            axis image
            
%% index Li
            subplot(2,2,2)
            tt = (1:length(Li))*(timelag/1000);
            semilogy(tt,Li,'k') % Li(t)
            hold on
            if ~isempty(Lc), semilogy(tt,Lc*ones(size(Li)),'Color',color_conf,'LineStyle','--'), end % seuil
            a = axis; axis([0 tt(end) a(3:4)]) % nfinal-Sm
            xlabel('time (s)'), ylabel('conf. index')
            title(['alpha_{conf} = ' num2str(alpha)])

            semilogy([0 tt(end)],[a(4) a(4)],'Color',color_dif,'LineWidth',5) % moments dif.
            if ~isempty(Lc)
                for nconf=1:Nconf(itraj)
                    tn = [begin_conf(nconf) end_conf(nconf)]*(timelag/1000);
                    semilogy(tn,[a(4) a(4)],'Color',color_conf,'LineWidth',7) % moments conf.
                    %a = axis; axis([0 tn(2) a(3:4)])
                end
            end
            hold off

%% Diff
            subplot(2,2,4)
            semilogy(tt(Dlocali>0),Dlocali(Dlocali>0)*.16^2/(timelag/1000),'k')
            xlabel('time (s)'), ylabel('D_{inst} (m/s)')
            a = axis; axis([0 tt(end) a(3:4)])
            
            if ~newfigs, fprintf('\r strike any key...'), pause, end
        end % if graph
        
        L(indi) = [zeros(ceil((Sm-1)/2),1); Li; zeros(floor((Sm-1)/2),1)];%L{itraj} = ;
        Dlocal(indi) = [zeros(ceil((Sm-1)/2),1); Dlocali; zeros(floor((Sm-1)/2),1)];%Dlocal{itraj} = ;
        % points dbut et fin complts par 0 pour garder meme taille
    end % if nfinal>Sm
    length_prev_trc = length_prev_trc+nfinal;
end % for itraj=1%:Ntraj

if Ntraj>trc(1,1)
    fprintf(repmat('\b',1,13))
    fprintf('%6i/%6i done \r', Ntraj, Ntraj) % affiche final
end

global USECELL
if isempty(USECELL), USECELL = 0; end

if ~USECELL
    lenConf = cell2mat(lenConf);
    lenFree = cell2mat(lenFree);
    sizeConf = cell2mat(sizeConf);
    sizeFree = cell2mat(sizeFree);
    beginConf = cell2mat(beginConf');
    endConf = cell2mat(endConf');
end

lenConf = lenConf'*timelag/1000;
lenFree = lenFree'*timelag/1000;
sizeConf = sizeConf';
sizeFree = sizeFree';
freqConf = freqConf';

clear global TRAJN

function trc_size = calcul_size(trc)
x = trc(:,3);
y = trc(:,4);
R2 = (x-mean(x)).^2+(y-mean(y)).^2;
R = R2.^0.5; %added by LCCE to calculate an actual radius, instead of an area
trc_size = mean(R);
%%%